import { HttpError } from 'wasp/server';

export const getService = async ({ id }, context) => {
  const service = await context.entities.Service.findUnique({
    where: { id },
    select: {
      id: true,
      title: true,
      description: true,
      category: true,
      packages: true,
      benefits: true,
      pricing: true
    }
  });

  if (!service) throw new HttpError(404, 'No service with id ' + id);

  return service;
}

export const getServices = async (args, context) => {
  if (!context.user) { throw new HttpError(401) }

  return context.entities.Service.findMany();
}